/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.thrown;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.capabilities.thrown.YetiThrowCapability;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateThrownPacket;

public class YetiThrowCapabilityHandler
implements YetiThrowCapability {
    private boolean thrown;
    private LivingEntity host;
    @Nullable
    private LivingEntity thrower;
    private int throwCooldown;

    @Override
    public void setEntity(LivingEntity entity) {
        this.host = entity;
    }

    @Override
    public void update() {
        if (this.getThrown()) {
            if (this.host.m_20096_() || this.host.m_6069_()) {
                this.setThrown(false, null);
            }
        } else if (this.throwCooldown > 0) {
            --this.throwCooldown;
        }
    }

    @Override
    public boolean getThrown() {
        return this.thrown;
    }

    @Override
    public void setThrown(boolean thrown, @Nullable LivingEntity thrower) {
        this.thrown = thrown;
        this.thrower = thrower;
        this.sendUpdatePacket();
    }

    @Override
    @Nullable
    public LivingEntity getThrower() {
        return this.thrower;
    }

    @Override
    public int getThrowCooldown() {
        return this.throwCooldown;
    }

    @Override
    public void setThrowCooldown(int cooldown) {
        this.throwCooldown = cooldown;
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        if (!this.host.m_9236_().m_5776_()) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.host), (Object)new UpdateThrownPacket((Entity)this.host, (YetiThrowCapability)this));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("yetiThrown", this.getThrown());
        tag.m_128405_("throwCooldown", this.getThrowCooldown());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setThrown(nbt.m_128471_("yetiThrown"), null);
        this.setThrowCooldown(nbt.m_128451_("throwCooldown"));
    }
}

